/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Data.h>
#include <Dialog.h>
#include <Control.h>

#include "Edit.h" 		// resource header file
 
class CEditDlg : public Dialog
{
public:
	CEditDlg() : Dialog(IDD_EDIT, "Edit")
	{
		
	}
	
	virtual int  DoModal(HWND hParent = NULL)
	{
		InitMsgMap();                    
		int nRet = Dialog::DoModal(hParent);  //Launch the dialog
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog)
	ON_BN_CLICKED(IDC_BUTTON1, AddText)
	ON_BN_CLICKED(IDC_CHECK1, OnClickRedText)
	ON_EN_CHANGE(IDC_EDIT1, OnEditChange)
	ON_EN_CHANGE(IDC_RICHEDIT1, OnRichEditChange)
EVENTS_END
	
	// Initial the dialog
	BOOL OnInitDialog()
	{
		// Initialize all interface controls
		m_EdBox = GetItem(IDC_EDIT1);
		m_richEdBox = GetItem(IDC_RICHEDIT1);
		m_btnCheck = GetItem(IDC_CHECK1);
		
		// Set the text on the Edit Box
		m_EdBox.Text="Welcome to Edit/Rich Edit example!";
		return true;
	}
	
	
	// Add text from Edit Box to Rich Edit Box
	BOOL AddText(Control oCntrl)
	{
		string str = m_EdBox.Text;
		m_EdBox.Text="";
		m_richEdBox.Text=str;
		return true;
	}
	
	// Change the color of text from default color to red
	BOOL OnClickRedText(Control oCntrl)
	{
		COLORREF cr = (m_btnCheck.Check ? RGB(255, 0, 0) : RGB(0, 0, 0));
		m_richEdBox.SetTextColor(0, -1, cr); // -1 = end of text
		return TRUE;
	}	
	
	// Updated the Rich Edit Box follow the change of the Edit Box
	BOOL OnEditChange(Control oCtrl)
	{
		m_richEdBox.Text = m_EdBox.Text;
		
		// Updated the color of text 
		COLORREF cr = (m_btnCheck.Check ? RGB(255, 0, 0) : RGB(0, 0, 0));
		m_richEdBox.SetTextColor(0, -1, cr); // -1 = end of text
		
		return TRUE;
	}
	
	// Updated the Edit Box follow the change of the Rich Edit Box
	BOOL OnRichEditChange(Control oCtrl)
	{
		m_EdBox.Text = m_richEdBox.Text;
		return TRUE;
	}

private:
	// Make all interface controls as data member
	Edit 		m_EdBox;		// Get Edit Box control
	RichEdit 	m_richEdBox;	// Get Rich Edit Box control
	Button 		m_btnCheck;		// Get Check Button control
	
};